dataset_class='safe'
gpu=0
adpt_td_weight=0.001
adpt_steps=1000
adpt_lr=0.05
use_wandb=1
export WANDB_INIT_TIMEOUT="300"

for env in  OfflineBallRun-v0 OfflineCarRun-v0 OfflineAntRun-v0 OfflineDroneRun-v0 OfflineCarCircle-v0 OfflineBallCircle-v0 OfflineDroneCircle-v0 OfflineAntCircle-v0 
do
    seed=0
    
    algo='Diffusion-QL'
    weight_bc_loss=20.0
    normalize_states=1
    pref_perturb_theta=0.0
    policy_freq=2
    gamma=0.99
    nohup python train_eval.py \
        --env $env \
        --seed $seed \
        --dataset $dataset_class \
        --gpu $gpu \
        --use_wandb $use_wandb \
        --pref_perturb_theta $pref_perturb_theta \
        --algo $algo\
        --normalize_states $normalize_states\
        --adpt_td_weight $adpt_td_weight\
        --adpt_lr $adpt_lr\
        --adpt_steps $adpt_steps\
        --policy_freq $policy_freq\
        --weight_bc_loss $weight_bc_loss\
        --gamma $gamma\
        > logs/${env}_${seed}.txt &
    seed=$(($seed+1))
    
    algo='PEDA'
    normalize_states=1
    pref_perturb_theta=0.0
    time_steps=200000
    nohup python train_eval.py \
        --env $env\
        --time_steps $time_steps\
        --seed $seed \
        --dataset $dataset_class \
        --gpu $gpu \
        --use_wandb $use_wandb \
        --pref_perturb_theta $pref_perturb_theta \
        --algo $algo\
        --normalize_states $normalize_states\
        --adpt_td_weight $adpt_td_weight\
        --adpt_lr $adpt_lr\
        --adpt_steps $adpt_steps\
        > logs/${env}_${seed}.txt &
    seed=$(($seed+1))
    gpu=$(($gpu+1))
done